<?php
require_once 'config.php';

// Force login
if (empty($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id'];

// Fetch wallet data (you can adjust table/columns)
$stmt = $pdo->prepare("
    SELECT 
        COALESCE(subventions,0) AS subventions,
        COALESCE(team_rewards,0) AS team_rewards,
        COALESCE(daily_cashback,0) AS daily_cashback,
        COALESCE(wallet_balance,0) AS wallet_balance
    FROM user_wallets 
    WHERE user_id = ?
");
$stmt->execute([$userId]);
$wallet = $stmt->fetch(PDO::FETCH_ASSOC) ?: [
    'subventions' => 0,
    'team_rewards' => 0,
    'daily_cashback' => 0,
    'wallet_balance' => 0
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard – My Wallet</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        :root{
            --green:#28a745;
            --light:#f8f9fa;
            --dark:#212529;
        }
        body{font-family:Arial,sans-serif;background:#f4f4f4;margin:0;}
        .header{background:var(--green);color:#fff;padding:1rem;text-align:center;position:relative;}
        .header a{color:#fff;text-decoration:none;position:absolute;left:1rem;top:1rem;}
        .wallet-grid{
            display:grid;
            grid-template-columns:repeat(2,1fr);
            gap:1rem;
            padding:1rem;
            max-width:600px;
            margin:0 auto;
        }
        .card{
            background:#fff;
            border-radius:8px;
            padding:1rem;
            text-align:center;
            box-shadow:0 2px 5px rgba(0,0,0,.1);
        }
        .card h3{font-size:1.8rem;margin:0.5rem 0 0;}
        .card p{margin:0;font-size:0.9rem;color:#666;}
        .tools{
            display:flex;
            justify-content:space-around;
            padding:1rem;
            background:#fff;
            margin:1rem;
            border-radius:8px;
            box-shadow:0 2px 5px rgba(0,0,0,.1);
        }
        .tool{
            text-align:center;
            color:var(--green);
            text-decoration:none;
            font-size:0.9rem;
        }
        .tool i{font-size:1.8rem;display:block;margin-bottom:0.3rem;}
        .functions{
            max-width:600px;
            margin:0 auto 4rem;
        }
        .func{
            display:flex;
            align-items:center;
            justify-content:space-between;
            background:#fff;
            padding:1rem;
            margin:0.5rem 1rem;
            border-radius:8px;
            box-shadow:0 1px 3px rgba(0,0,0,.1);
        }
        .func i{font-size:1.5rem;color:var(--green);}
        .bottom-nav{
            position:fixed;
            bottom:0;
            left:0;
            right:0;
            background:#fff;
            display:flex;
            justify-content:space-around;
            padding:0.8rem 0;
            box-shadow:0 -2px 5px rgba(0,0,0,.1);
        }
        .bottom-nav a{color:var(--green);text-decoration:none;text-align:center;font-size:0.8rem;}
        .bottom-nav i{font-size:1.5rem;display:block;}
        .active{color:var(--dark);}
    </style>
</head>
<body>

<div class="header">
    <a href="logout.php"><i class="fas fa-times"></i></a>
    <h1>Facebook Lite</h1>
</div>

<div class="wallet-grid">
    <div class="card">
        <h3><?= number_format($wallet['subventions'], 2) ?></h3>
        <p>Subventions</p>
    </div>
    <div class="card">
        <h3><?= number_format($wallet['team_rewards'], 2) ?></h3>
        <p>Team Rewards</p>
    </div>
    <div class="card">
        <h3><?= number_format($wallet['daily_cashback'], 2) ?></h3>
        <p>Daily Cashback</p>
    </div>
    <div class="card">
        <h3><?= number_format($wallet['wallet_balance'], 2) ?></h3>
        <p>Wallet Balance</p>
    </div>
</div>

<div class="tools">
    <a href="#" class="tool"><i class="fas fa-exchange-alt"></i>Transfer</a>
    <a href="#" class="tool"><i class="fas fa-sign-in-alt"></i>Sign In</a>
    <a href="#" class="tool"><i class="fas fa-money-bill-wave"></i>Withdraw</a>
</div>

<div class="functions">
    <div class="func"><i class="fas fa-credit-card"></i> <span>Payee Method</span> <i class="fas fa-chevron-right"></i></div>
    <div class="func"><i class="fas fa-box"></i> <span>Product Detail</span> <i class="fas fa-chevron-right"></i></div>
    <div class="func"><i class="fas fa-truck"></i> <span>Shipping Address</span> <i class="fas fa-chevron-right"></i></div>
</div>

<div class="bottom-nav">
    <a href="#"><i class="fas fa-home"></i>Home</a>
    <a href="#"><i class="fas fa-shield-alt"></i>Authentication</a>
    <a href="#"><i class="fas fa-gift"></i>Welfare</a>
    <a href="#"><i class="fas fa-user-friends"></i>Agent</a>
    <a href="dashboard.php" class="active"><i class="fas fa-user"></i>Mine</a>
</div>

</body>
</html>